# Charity Notes 05: 箴言14:34的讨论

[TOC]

这节课的主要内容是研究一个塔木德经文段落，即箴言（Proverb）中的一节经文（14:34）。

> .צְדָקָה תְרוֹמֵם-גּוֹי;    וְחֶסֶד לְאֻמִּים חַטָּאת
>
> Righteousness(צְדָקָה) exalts a nation, but sin condemns any people.
>
> 公义使邦国高举。罪恶是人民的耻辱。 

这里的 צְדָקָה 指的是一般意义的正义，而非慈善。但是这两句话合在一起是奇怪的，因为第二句话的直译是，“and the *chessed* of the people is *chatat*”。

“==chessed==”意为仁慈的、善良的行为，这种理解来自于诗篇和Hosea中。然而在早期的圣经希伯来文中，这个词也具有“憎恨”（abomination）或者“被诅咒”（cursed）的含义。类似的，“==chatat==” 这个词也可以解释为“罪”（sin）或者“赎罪祭”（sin offering，赎罪的牺牲）。这节经文中的这两个词都有可能的积极意义或消极意义。另外，关于这节经文的两个部分之间的关系，它可以是**对比的**，也可以是**平行的**。

然而，所有人似乎都同意这节经文的第一部分是说正义是积极的，但第二部分呢？

在以色列学者的解释中，第二段应该这样理解：“And sin is an abomination for the people.”(罪恶是人民的耻辱)。 然而，一位中世纪时期的评论家亚伯拉罕·伊本·埃兹拉（==Abraham ibn Ezra==）将第二部分视为与第一部分平行。他认为“chessed”意味着善行（good deeds）而“chatat”意味着赎罪祭（sin-offering）。根据他的理论，没有必要重新安排这些词。这句话教导说“人民的善行相当于带来赎罪祭”。换句话说，这节经文的两个部分都在说“慈善事业”和“民族”所带来的善行。 Ibn Ezra的方法尤其重要，因为它很可能反映了犹太教徒在犹太教教士时代（塔木德时期）理解这节经文的方式。

值得注意的是，根据对这节经文的各种解读，<u>犹太人和非犹太人之间没有区别</u>。这节经文使用通用术语“goy” - 我们将其翻译为“民族”和 leumim  - 我们将其翻译为“人”。所以在 baraita 中，伟大的学者Rabban Yoḥanan ben Zakkai 认为这句经文应该理解为：

> Just as a sin-offering atones for Israel, so charity atones for the nations of the world.
>
> **慈善事业是对世界各国的赎罪，正如赎罪祭之于以色列。**

不过有趣的是，==Yoḥanan ben Zakkai==给他的学生一个复杂的问题的解答，然后让其决定哪个答案是最正确的。他们讨论的重点是正是上述经文。



## 巴比伦塔木德拉比们的深入讨论

回到巴比伦塔木德  Bava Batra 10b 里的故事，Yohanan ben Zakkai 给他的学生提出一个问题： 

> 孩子们，下面的经文是什么意思？
>
> “Righteousness [read “charity”] exalts a nation, and the kindness of the peoples is like a sin[offering]”

老师和学生都理解这节经文的简单含义，就是说包括非犹太人在内的所有人的慈善事业和善行都是积极的。他要求他的学生发挥创造力，并将这节经文转化为对非犹太人慈善事业做出负面评价的事情。<u>箴言“正义“的诗句的前半部分提升了一个民族，指的是以色列人的慈善事业，并且是积极的。然而，下半部分的“人民的善意就像一个罪”指的是非犹太人的慈善，被视为消极的“像罪”。</u>

以下是他的学生的解读：

- 【社会地位解读】拉比 ==Eliezer== 回答道，“正义高举一个国家”;这些是指以色列人，正如历代志下17:21说的那样。 “但是人民的善意就是罪，” 这意味着其他世界各国所做的“慈善和仁慈行为”都被视为对他们的罪，因为他们只是为了<u>提升自己的声望</u>，这样做只是为了他们自己的利益。

- 【政治解读】拉比 ==Yehoshua== 回答道，后一句“但是人民的善良就是罪”意味着其他国家的慈善或者仁慈行为是一种罪，因为他们<u>只是为了使他们的统治永久化</u>。正如 Daniel 说服Nebuchadnezzar中说的，“这能延长您的宁静。”（Daniel 4:24）
- 【傲慢解读】拉比 Gamliel回答道，后一句“但是人民的善良就是罪”意味着其他国家的慈善或者仁慈行为是一种罪，因为因为他们只是为了通过他们傲慢地（haughtily ）执行它们。这在箴言21:24和Zephaniah 1:15有体现。

对于上述拉比们的讨论，我们分析如下：

1. Eliezer和Yehoshua的前两种方法有类似的东西，但重点略有不同。他们认为他国的慈善事业都不值得被赞扬，因为善行的背后动机并不纯洁。行善的人不是出于宗教或人道主义关注的动机，而是仅仅是功利主义者，自我利益者。两个学生之间的唯一区别在于他们对自身利益的描述。Eliezer认为不是关于政治而是社会地位的动机。这与我们在**希腊世界**中的 “euergetism” 的中心地位是类似的。而 Yehoshua 认为这是一种政治动机，是**罗马统治者**政策的核心。
2. 共同点是当他们的动机远离圣经和塔木德的宗教方法（后来被基督徒和穆斯林采用）时，他们认为奖励善行是不对的 。<u>不受宗教或人道主义驱动的慈善和善行不能被视为值得钦佩的事物</u>。

最后两段中， Nehunya 和老师的总结。==Nehunya==没有参与解释为什么认为非犹太人的善行毫无价值而应该被认为是“罪行”。他专注于创造性的阅读箴言的经文以至于慈善和善行与犹太人相关，而非犹太人得到罪。他用了创造性的==断句==：

> “Righteousness [read “charity”] exalts a nation and kindness” is referring to Israel; and in addition, “of the peoples is sin.” 

接着老师拉比 Yohanan ben Zakkai 说，Nehunya 的观点似乎比我们都要更准确，因为“他将慈善和仁慈都分配给以色列，并为世界各国人民分配罪。” 所以他显然喜欢最牵强（far-fetched）和最负面的解释！



## 问题的由来

我们知道在baraita中，Yohanan 对非犹太人的慈善行为的看法并没有如此激烈，但在Batra 10b中 Yohanan 却喜欢最牵强的解释。学者 ==Ephraim Urbach== 提出了一个有意义的历史解释：他说早期和之后的 Yohanan 差异来自于他**经历了罗马军队毁坏耶路撒冷和圣殿**的事件。人们可以很容易地理解为什么经历过这种事件的人会对他残酷的敌人变得不那么慷慨。

在 Avot d’Rabbi Natan a 中有记载：

> 一次在耶路撒冷圣殿毁灭后，拉比 Yohanan和他的学生Yehoshua 一起走路。Yehoshua说，“对于我们来说，以色列赎罪的地方被摧毁了。” 拉比 Yohanan 说，“不要生气，我的孩子，因为我们有另一种更伟大赎罪方式（atonement），这是宝石般的善良行为，正如经文所讲，‘我渴望的是善良而不是燔祭’。”

Urbach 认为只有犹太人拥有寺庙和祭祀的时候，拉比 Yohanan 才会对罗马慈善事业采取暧昧态度。而在罗马人摧毁圣殿只是以善行作为赎罪手段，他觉得没有动力接受将这种善行作为赎罪的方式。因此，他指示他的学生针对这段箴言提出创造性的方法，以确保罗马人的善行不会得到回报，而是作为罪行而被惩罚。因此，他对 Nehunya 创造性的解读更为推崇。



whzecomjm
2019年7月3日